/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Last Modified:	5/20/98									*
*	Author:			Jennifer Weston							*
***********************************************************************/
#include "BlitheConst.h"
#include <OS.h>

/*

	Class:			BlitheDictionary
	Inherits From:	<none>
	Description:		This class is a wrapper around the Blithe C API. It also provides additional
					functionality, such as creating a BPopupMenu of language names and memory
					management.
	
*/
class BlitheDictionary {
	public:
		//	Constructors/Destructor
		BlitheDictionary(int32 dictionary = BL_DEFAULT_LANGUAGE,bool checkForAppDictionary=false);
		virtual ~BlitheDictionary(void);
	
		//	Getters
		int32 AppLanguageID(void);
		char* AppLanguageName(char *inBuffer=NULL,int32 inBuffLength=0);
		char* Entry(int32 id, int32 dictionary = BL_DEFAULT_LANGUAGE,char *inBuffer=NULL,int32 inBuffLength=0);
		void* Blob(uint32 type, int32 id, size_t* outBlobSize, int32 dictionary, void* inBuffer=NULL, size_t inBuffLength=0);
		int32 LanguageList(char** outList);
		char* LanguageName(int32 id,char *inBuffer=NULL,int32 inBuffLength=0);
		int32 LanguageID(char *name);
		BPopUpMenu *LanguagePopupMenu(void);
		void SetAppLanguage(int32 inLangID);
		BBitmap* BlitheBitmap(void);
	
	private:
		void ClearTemp(void);
		int32 appLanguage;
		char *temp;
};

class BlitheException {
	public :
	    BlitheException(int32 theType) { type = theType; };
	    virtual ~BlitheException() {};
	    virtual int32 what(void) {return type;};
	private :
	    int32		type;
};
